/**
  ********************************************************************************
  *
  * @file    hal_flash.h
  * @brief   Header file of Flash driver
  *
  * @version V1.0
  * @data    22 Aug 2018
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  ********************************************************************************
  */


#ifndef __HAL_FLASH_H__
#define __HAL_FLASH_H__


#include <hic.h>
#include "type.h"
#include "hal_base.h"

/**
  * @addtogroup ES7P203_HAL
  * @{
  */

/**
  * @addtogroup Flash
  * @{
  */

/**
  * @defgroup Flash_Public_Types flash Public Types
  * @{
  */
  
#define FLASH_END		0x1FFF
#define FLASH_UNLOCK()		(IAPUL = 0xA5)
#define FLASH_LOCK()		(IAPUL = 1)
#define FLASH_ERASE()		(IAPERSS = 0xAE)
#define FLASH_PROGRAMME()	(IAPPRGS = 0xD5)

#define IS_FLASH_ADDR(x)	(((x) >= 0x1E00) && \
				 ((x) <= 0x1FFF))
/**
  * @}
  */


/**
  * @addtogroup Flash_Public_Functions
  * @{
  */
						 
hal_status_t flash_write(uint16_t addr, uint16_t *buf, uint16_t len);
hal_status_t flash_erase(uint16_t addr);
hal_status_t flash_read(uint16_t *ram_addr, uint16_t addr, uint16_t len);

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#endif /* __HAL_FLASH_H */
